* Replication file Karatasli (2020) IJCS 
*Tables 2, 3 and 6

/*
Cite: 
Karataşlı, Şahan Savaş. (2020) Capitalism and nationalism in the longue durée: Hegemony, crisis, and state-seeking nationalist mobilization, 1492–2013. International Journal of Comparative Sociology. 61(4):233-263. doi:10.1177/0020715220946473
*/

use  Karatasli_SSNM_2020.dta, clear

ssc install asdoc, replace
ssc install estout, replace

sort cowcode year
xtset cowcode year


*Table 2
sum total2  ethfrac  relfrac L1.irst L1.gdppc L1.glob L1.centercap2_c ns5emp nsf5neigh L1.total_neigh L1.natorgyesno natorglag  L1.impdep L1.warsinemp L1.numwar L1.crisis L1.gsp   L1.financialization  middleeast eeurop africa asia oceania lamerica  year

*Table 3
pwcorr total2  ethfrac  relfrac L1.irst L1.gdppc L1.glob L1.centercap2_c  ns5emp nsf5neigh L1.total_neigh L1.natorgyesno natorglag  L1.impdep  L1.warsinemp L1.numwar L1.crisis L1.gsp   L1.financialization  year
asdoc cor total2  ethfrac  relfrac irst gdppc glob centercap2_c  ns5emp nsf5neigh  natorgyesno natorglag  impdep  warsinemp numwar crisis gsp   financialization total_neigh year, dec(2) vallab save(corr.doc) title(Correlation) 

*Table 6
nbreg total2  ethfrac  relfrac L1.irst L1.gdppc L1.glob L1.centercap2_c   ns5emp nsf5neigh  L1.natorgyesno natorglag  L1.impdep L1.centerimdep2 L1.warsinemp L1.numwar L1.crisis L1.gsp   L1.financialization  L1.total_neigh middleeast eeurop africa asia oceania lamerica  year, cluster(cowcode) iter(10)
estimate store Model_all
fitstat

nbreg total2   ethfrac  relfrac  middleeast eeurop africa asia oceania lamerica  year, cluster(cowcode)
estimate store Model_CULT
fitstat

nbreg total2   L1.irst L1.gdppc  L1.glob L1.centercap2_c   middleeast eeurop africa asia oceania lamerica  year, cluster(cowcode)
estimate store Model_PE
fitstat

nbreg total2   ns5emp nsf5neigh L1.natorgyesno natorglag L1.centercap2_c  L1.impdep L1.centerimdep2 L1.warsinemp L1.numwar middleeast eeurop africa asia oceania lamerica year , cluster(cowcode)
estimate store Model_HI
fitstat

nbreg total2   L1.centercap2_c  ns5emp nsf5neigh L1.natorgyesno natorglag L1.impdep L1.numwar L1.warsinemp  middleeast eeurop africa asia oceania lamerica L1.crisis  L1.gsp  L1.total_neigh L1.financialization year, cluster(cowcode)
estimate store Model_HSCT
fitstat

nbreg total   L1.centercap2_c  ns5emp nsf5neigh L1.natorgyesno natorglag L1.impdep L1.numwar L1.warsinemp  middleeast eeurop africa asia oceania lamerica L1.crisis L1.gsp  L1.total_neigh L1.financialization year, cluster(cowcode)
estimate store Model_HSCT2
fitstat

logit totald L1.centercap2_c  ns5emp nsf5neigh L1.natorgyesno natorglag L1.impdep L1.numwar L1.warsinemp  middleeast eeurop africa asia oceania lamerica L1.crisis L1.gsp  L1.total_neigh L1.financialization year, cluster(cowcode)
estimate store Model_HSCT3
fitstat

esttab Model_all Model_CULT  Model_PE Model_HI Model_HSCT Model_HSCT2 Model_HSCT3,  b(%8.3f) label star(* 0.05 ** 0.01 *** 0.001)
esttab Model_all Model_CULT  Model_PE Model_HI Model_HSCT Model_HSCT2 Model_HSCT3 using "Table6.csv", title("Main Table") star(* 0.05 ** 0.01 *** 0.001) b(%8.3f)  replace label

*VIF Scores

reg total2   ethfrac  relfrac  middleeast eeurop africa asia oceania lamerica  year, cluster(cowcode) 
vif

reg L1.irst L1.gdppc  L1.glob L1.centercap2_c   middleeast eeurop africa asia oceania lamerica  year, cluster(cowcode)
vif

reg total2   ns5emp nsf5neigh L1.natorgyesno natorglag L1.centercap2_c  L1.impdep L1.centerimdep2 L1.warsinemp L1.numwar middleeast eeurop africa asia oceania lamerica year , cluster(cowcode)
vif

reg total2   L1.centercap2_c  ns5emp nsf5neigh L1.natorgyesno natorglag L1.impdep L1.numwar L1.warsinemp  middleeast eeurop africa asia oceania lamerica L1.crisis  L1.gsp  L1.total_neigh L1.financialization year, cluster(cowcode)
vif

reg total   L1.centercap2_c  ns5emp nsf5neigh L1.natorgyesno natorglag L1.impdep L1.numwar L1.warsinemp  middleeast eeurop africa asia oceania lamerica L1.crisis L1.gsp  L1.total_neigh L1.financialization year, cluster(cowcode)
vif

reg totald L1.centercap2_c  ns5emp nsf5neigh L1.natorgyesno natorglag L1.impdep L1.numwar L1.warsinemp  middleeast eeurop africa asia oceania lamerica L1.crisis L1.gsp  L1.total_neigh L1.financialization year, cluster(cowcode)
vif





